Attribute VB_Name = "Module2"


'  DDMB32.BAS
'  ==========

'DDMB structure for 32-bit Visual Basic (Version 5.0) programs
'NB 32-bit VB has a different default aligning to 16-bit VB - so that we have
' to split up many fields into smaller segments
'NB VB 5.0 uses the new type BYTE. We now use this instead of String * 1

'NB DD32 should be protected using the Object Method (and not your program)
'If you are working in the VB development environment then you
'must place DD32.dll in the WINDOWS/SYSTEM directory
'When you run your VB executable it will also look in the program directory


Type DDMB
    B1 As String * 1
    B2 As String * 1
    B3 As String * 1
    B4 As String * 1
    Func As Byte
    Rcodelo As Byte
    Rcodehi As Byte
    ExtErr1 As Byte
    ExtErr2 As Byte
    ExtErr3 As Byte
    ExtErr4 As Byte
    ExtErr5 As Byte
    ExtErr6 As Byte
    ExtErrRem As String * 4
    Vers As String * 2
    DongleNumber1 As Byte
    DongleNumber2 As Byte
    DongleNumber3 As Byte
    DongleNumber4 As Byte
    Sdsn1 As Byte
    Sdsn2 As Byte
    ProductCode As String * 9
    ProgramName As String * 13
    Execs1 As Byte
    Execs2 As Byte
    ExpDay As Byte
    ExpMonth As Byte
    ExpYear1 As Byte
    ExpYear2 As Byte
    Feature1 As Byte
    Feature2 As Byte
    Feature3 As Byte
    Feature4 As Byte
    SecureMsg As String * 256
    UpdateNumber1 As Byte
    UpdateNumber2 As Byte
    Flags1 As Byte
    Flags2 As Byte
    DosTime1 As Byte
    DosTime2 As Byte
    DosTime3 As Byte
    DosTime4 As Byte
    Reserved1 As String * 4
    RWOffset1 As Byte
    RWOffset2 As Byte
    RWLength1 As Byte
    RWLength2 As Byte
    NotUsed As String * 4
    NetUsers1 As Byte
    NetUsers2 As Byte
    NetUserData1 As Byte
    NetUserData2 As Byte
    NetUserData3 As Byte
    NetUserData4 As Byte
    Res2 As Byte
    USB As Long
    ResExpand As String * 168
End Type

Type DDCB
'the fixed portion
    C1 As String * 1
    C2 As String * 1
    C3 As String * 1
    C4 As String * 1
    SdSn As Integer
    ProductCode As String * 9
    ExtErr1 As Byte
    ExtErr2 As Byte
    ExtErr3 As Byte
    ExtErr4 As Byte
    ExtErr5 As Byte
    ExtErr6 As Byte
    NumBlocks1 As Byte
    NumBlocks2 As Byte
    
'one "block"
    DongleSn1 As Byte
    DongleSn2 As Byte
    DongleSn3 As Byte
    DongleSn4 As Byte
    Pcode As String * 9
    UpdateNum As Integer
End Type

Type DDERR
    B1 As String * 1
    B2 As String * 1
    B3 As String * 1
    B4 As String * 1
    B5 As String * 1
    ExtErr1 As Byte
    ExtErr2 As Byte
    ExtErr3 As Byte
    ExtErr4 As Byte
    ExtErr5 As Byte
    ExtErr6 As Byte
End Type

Declare Function DD32 Lib "DD32T.DLL" (DD As DDMB) As Integer
Declare Function DD32VB Lib "DD32T.DLL" (DD As DDMB, ByVal String1 As Any) As Integer

Declare Function DDinfo Lib "ddchange.dll" Alias "DDINFO" (DD As DDCB) As Long
Declare Function DDCHANGE Lib "ddchange.dll" (ByVal UpdateCode As Any, ErrCode As DDERR, ByVal Quiet As Long) As Long
Declare Function lstrcpy Lib "Kernel" (ByVal lpString1 As Any, ByVal lpString2 As Any) As Long

Global DD As DDMB
Global DDI As DDCB
Global ErrorCode As DDERR
Global serialno As String
Global SAVEOPTIONS As String

'Add2Bytes converts two Bytes into an Integer

Function Add2Bytes(Hi As Byte, Lo As Byte) As Integer

    Add2Bytes = CInt(Hi) * 256 + CInt(Lo)

End Function


'Add4Bytes converts four Bytes into a Long

Function Add4Bytes(HiHi As Byte, HiLo As Byte, LoHi As Byte, LoLo As Byte) As Long

    Add4Bytes = CLng(HiHi) * 16777216 + CLng(HiLo) * 65536 + CLng(LoHi) * 256 + CLng(LoLo)

End Function

'Use them like this:

'SDSN = Add2Bytes(ddmb.Sdsn2, ddmb.Sdsn1)
'DongleNumber = Add4Bytes(ddmb.DongleNumber4, ddmb.DongleNumber3, ddmb.DongleNumber2, ddmb.DongleNumber1)
Sub Dongle_Write_Bytes()
' code to write the 13 bytes: 'DinkeyDongles' to beginning of the user data area
Dim DataString As String * 64
Dim RWDataPtr As Long

On Error Resume Next
DD.B1 = "D"
DD.B2 = "D"
DD.B3 = "M"
DD.B4 = "B"
DD.Flags1 = 0
DD.Flags2 = 0
DD.Func = 1                 'check protection and write data
DD.RWLength1 = 64           'set parameters to 0
DD.RWLength2 = 0            'thirteen bytes
DD.RWOffset1 = 0            'at offset 0 in user data
DD.RWOffset2 = 0
DataString = "DDAT" & "FFTFFFTTFFFFFTFT" 'initialise string

l% = DD32VB(DD, DataString)               'call DD32VB

If l% <> 0 Then
    MsgBox "Dinkey Dongle protection error " + Str$(l) + _
            "  Extended Error code: " + Hex(DD.ExtErr1) + Hex(DD.ExtErr2) + _
            Hex(DD.ExtErr3) + Hex(DD.ExtErr4) + Hex(DD.ExtErr5) + Hex(DD.ExtErr6), _
            vbOKOnly, "Error"
Else
    MsgBox "Dinkey dongle data written sucessfully."
End If

End Sub
Sub dongle_substract(subonemin As Boolean)
On Error Resume Next
        
   If Not (Dir("S:\MEMSTICK.IND", vbHidden) <> "") Then
        If subonemin Then
            DD.Func = 3   'UPDATES PARAMETERS DOES NOT START NETWORK USER
        Else
            DD.Func = 2   ' Does not update
        End If
        DD.RWLength1 = 0           'set parameters to 0
        DD.RWLength2 = 0            'thirteen bytes
        DD.RWOffset1 = 0            'at offset 0 in user data
        DD.RWOffset2 = 0
        l% = DD32(DD)
        If l% <> 0 Then
            MsgBox "Security key not detected or time expired. Please plug it and press Enter.", vbExclamation
            l% = DD32(DD)
            If l% <> 0 Then
                MsgBox "Security key not detected or time expired. Program terminating.", vbCritical
                End
            End If
        ElseIf phonecard Then
            minutesleft = Add2Bytes((DD.Execs2), (DD.Execs1))
            If minutesleft >= 0 And minutesleft <= 65535 Then
                If minutesleft = 600 Then
                    MsgBox "Warning: You have 10 hours left on your Transtation account. Please recharge it. ", vbExclamation
                ElseIf minutesleft = 60 Then
                    MsgBox "Warning: You have 1 hour left on your Transtation account. Please recharge it as soon as possible.", vbExclamation
                ElseIf minutesleft <= 0 Then
                    MsgBox "Sorry, your account has expired and the program will be closed." & Chr(13) & "Please contact TMsupport@thekitchen.tv to recharge your account.", vbExclamation
                    End
                End If
            End If
        End If
    End If
End Sub

Sub Dongle_Read_Bytes()
Dim DataString As String * 64
Dim RWDataPtr As Long

On Error Resume Next
' code to read 13 bytes from the beginning of the user data area
DD.B1 = "D"
DD.B2 = "D"
DD.B3 = "M"
DD.B4 = "B"
DD.Flags1 = 0
DD.Flags2 = 0
DD.Func = 2                 'check protection and read data
DD.RWLength1 = 64           'set parameters to 0
DD.RWLength2 = 0            'thirteen bytes
DD.RWOffset1 = 0            'at offset 0 in user data
DD.RWOffset2 = 0
DataString = "DDAT"         'initialise string to be filled in

l% = DD32VB(DD, DataString)               'call DD32

If l% <> 0 Then
    MsgBox "Dinkey Dongle protection error " + Str$(l) + _
            "  Extended Error code: " + Hex(DD.ExtErr1) + Hex(DD.ExtErr2) + _
            Hex(DD.ExtErr3) + Hex(DD.ExtErr4) + Hex(DD.ExtErr5) + Hex(DD.ExtErr6), _
            vbOKOnly, "Error"
Else
    MsgBox "Dinkey Dongle Data Area contains: " + Right(DataString, Len(DataString) - 4), vbOKOnly

MsgBox "Dinkey Features=" & DD.Feature1 & "--" & DD.Feature2 & "--" & DD.Feature3 & "--" & DD.Feature4
End If

End Sub




